﻿param(
    [string]$HomeDir,
    [string]$InstallDir,
    [string]$DockerTag,
    [string]$Release,
    [string]$WrappersDir
)

mkdir -p $WrappersDir

Copy-Item -Path "$InstallDir/share/qtcreator/apptool/wrappers/windows/*" $WrappersDir

Set-Location -Path $WrappersDir

$InstallDirWithSlash = $InstallDir.Replace('\','/')

$files = Get-ChildItem $WrappersDir
foreach ($f in $files){
    echo $f

    ((Get-Content -path $f -Raw) -replace '@home_dir@',$HomeDir) | Set-Content -Path $f
    ((Get-Content -path $f -Raw) -replace '@install_dir@',$InstallDir) | Set-Content -Path $f
    ((Get-Content -path $f -Raw) -replace '@install_dir_unix@',$InstallDirWithSlash) | Set-Content -Path $f
    ((Get-Content -path $f -Raw) -replace '@docker_image_tag@',$DockerTag) | Set-Content -Path $f
    ((Get-Content -path $f -Raw) -replace '@release@',$Release) | Set-Content -Path $f
}
